---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：1-next build バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：根拠不足
  2. **ビルドトレースの詳細仕様**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/cli/next-build.ts` - CLIエントリポイント
- E-02: `packages/next/src/build/index.ts` - ビルドコア処理
- E-03: `packages/next/src/lib/bundler.ts` - バンドラー選択ロジック（参照のみ）
- E-04: `packages/next/src/lib/get-project-dir.ts` - ディレクトリ解決（参照のみ）
- E-05: `packages/next/src/lib/resolve-build-paths.ts` - ビルドパス解決（参照のみ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NextBuildOptions型に基づくCLIオプション | E-01 | ○ |
| C-02 | Turbopack/Webpack/Rspack選択可能 | E-01 (parseBundlerArgs) | ○ |
| C-03 | プロジェクトディレクトリのexistsSyncチェック | E-01 (L101) | ○ |
| C-04 | SIGTERM/SIGINTシグナルハンドラ | E-01 (L39-46) | ○ |
| C-05 | experimentalAnalyzeはTurbopackのみ対応 | E-01 (L68-72) | ○ |
| C-06 | マングリング無効時の警告 | E-01 (L74-78) | ○ |
| C-07 | debugBuildPathsによる選択的ビルド | E-01 (L108-124) | ○ |
| C-08 | メモリデバッグモードの有効化/無効化 | E-01 (L94-97, L159-162) | ○ |
| C-09 | エラーコード分類（INVALID_RESOLVE_ALIAS等） | E-01 (L148-152) | ○ |
| C-10 | build関数への引数渡し | E-01 (L126-138) | ○ |
| C-11 | ビルド成果物は.nextディレクトリ | E-02 (定数定義) | ○ |
| C-12 | 各種マニフェストファイル生成 | E-02 (import文) | ○ |
| C-13 | テレメトリデータの送信 | E-02 (telemetry import) | ○ |
| C-14 | TypeScript型チェック | E-02 (startTypeChecking import) | ○ |
| C-15 | lockfilePatchPromiseによるロック機構 | E-02 (import) | ○ |
| C-16 | 環境変数NEXT_DEBUG_BUILDの使用 | E-01 (L130) | ○ |
| C-17 | パフォーマンス要件の具体値（数十秒～数十分） | **根拠なし** | △ |
| C-18 | ビルドトレース収集の詳細仕様 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体値はプロジェクト規模に依存するため、ソースコードから定量的根拠を得られない
  - 候補：Next.jsドキュメント / ベンチマーク結果 / CI/CDの実行ログ
- ビルドトレースの詳細仕様はcollectBuildTracesの実装を参照する必要がある
  - 候補：`packages/next/src/build/collect-build-traces.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CLIオプションやエラー処理は実コードから高い信頼度で記述
- 0: 低リスク - マニフェスト一覧はimport文から網羅的に抽出
- 1: 中リスク - パフォーマンス要件は推定値のため、実環境での検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] CLIオプション一覧がNextBuildOptions型と一致しているか確認
- [ ] エラーコード一覧が実際のcatch節と一致しているか確認
- [ ] マニフェストファイル一覧が最新のビルド出力と一致しているか確認
- [ ] パフォーマンス要件の記述が実環境の期待値と整合するか確認
